# 鱼皮的 AI 指南 - 2、AI 实用工具

> ⭐️ 推荐观看视频版：[https://www.bilibili.com/video/BV1i9Z8YhEja](https://www.bilibili.com/video/BV1i9Z8YhEja/)



如今 AI 相关的工具百花齐放，像我也精心整理过几十个主流的 AI 工具，覆盖 AI 对话、写作、图像、视频、音频、办公、编程等各个应用场景。

![](https://pic.yupi.icu/1/1743562426248-d0c54b5b-eae0-452a-81e7-1d81eda4295b.png)

哇，这么多工具，看得眼都花了！不过别担心，我们不必都去学习。

下面我会着重为大家分享在程序员日常工作中非常实用的一整套工具链，如果你还不满足，想学习更多工具，可以看看我 [免费开源的 AI 知识库](https://github.com/liyupi/ai-guide)，里面还有很多 AI 使用技巧、行业资讯、应用场景、资源干货的分享哦。

![](https://pic.yupi.icu/1/image-20250402113043945.png)



### 1、开发类工具

#### 日常问题解决与知识搜索 - AI 对话产品

一些简单的问题和内容搜索可以直接使用 AI 对话产品来搞定，比如 DeepSeek、元宝、豆包、通义千问、文心一言、Kimi、GPT、Claude。像我自己一般会同时打开好几个网站一起用，挑选最合适的回答。觉得麻烦的话，也可以尝试下网友自制的 [聚合 AI 应用](https://botgroup.chat/)，能直接在一个聊天框里和所有主流大模型对话。

![](https://pic.yupi.icu/1/1743562538451-67f6a7c2-bfeb-4138-a36e-20b8116b985b.png)

#### 小项目与新项目开发 - Cursor

如果要开发小项目或新项目，我建议使用 Cursor，一款专为编程打造的 AI 工具。新建一个文件夹，打开 AI 对话框，选择 Agent 智能体模式和大模型，然后输入一段提示词，接下来只需默默等待，AI 就会自主帮你生成一个完整的网站，真的一行代码都不用写！

![](https://pic.yupi.icu/1/1743562626421-7c4df1cd-e601-4fb5-9afe-bfef87905cdf.png)

这也就是为什么现在突然有了那么多奇奇怪怪大开脑洞的应用，像我之前分享过的什么赛博拉屎，有了 Cursor，人人都能搞网站了。

#### 老项目与大项目维护 - AI IDE 插件

不过对于老项目或者大项目的开发，AI 更适合作为辅助，我会选择在主流开发工具（比如 VSCode、JetBrains IDE）中安装插件来使用 AI，比如智谱 CodeGeex、JetBrains Assistant、通义灵码、GitHub Copilot 等。

![](https://pic.yupi.icu/1/1743562734642-1d70691b-4a41-485a-8085-0c01fd6c2662.png)

这些工具的使用方式都差不多，可以将项目代码作为上下文信息，生成补全代码、分析错误信息改 Bug、解释代码、生成单元测试、生成提交信息等等，全部在 IDE 内完成，不用来回跳转到其他 AI 产品，开发效率会更高。

![](https://pic.yupi.icu/1/1743562794206-77f048df-07d5-48ce-a810-528df90727ac.png)

#### 其他开发场景

日常开发一般使用上面这些工具就够了，如果你有一些特殊需求，也可以使用对应的 AI 工具来解决。

想更高效地管理数据库，可以使用 [Chat2DB](https://chat2db-ai.com/)，借助 AI 一句话完成数据管理、SQL 生成、数据分析和可视化。

![](https://pic.yupi.icu/1/1743562852453-276ddd5a-eafa-4372-aea8-2815030f0cef.png)

想对 API 接口进行测试，可以使用 [PostMan](https://www.postman.com/)，借助 AI 快速生成不同场景下的测试用例和接口文档。

![](https://pic.yupi.icu/1/1743562906402-76a50cc8-844c-4332-aff1-d5124af52e67.png)

想提交代码或部署项目，可以使用 [Warp AI](https://www.warp.dev/warp-ai)，自动帮你把自然语言转换为正确的命令并执行，再也不用记忆复杂的命令，简化了终端操作。

![](https://pic.yupi.icu/1/1743562956833-6e136aeb-43bb-4330-9b9d-5e64685a5349.png)

### 2、写作类工具

程序员的工作除了开发之外，也离不开写文档和作图。

#### 写作与文档编写 - 语雀 AI

团队协作文档我用的比较多的还是语雀，本身功能就比较丰富，Markdown 语法写文章、嵌入画板等工具、一键进入演讲模式等等。现在它内嵌了 DeepSeek 大模型和 AI 助手功能，可以帮你快速完善丰富指定内容、改写口吻、总结转写内容，做笔记也是比较合适的。

![](https://pic.yupi.icu/1/1743563052462-1f41204b-cdc5-442a-b19a-303b3268830a.png)

#### 作图 - 豆包 + Mermaid

程序员在写技术文档时，一般会通过各种流程图、架构图来让文档更好理解，看起来也更高大上。有了 AI 后，很多图例不用自己手绘了，我可以直接把作图的信息提供给豆包或者其他 AI，让它生成 Mermaid 文本作图语法，接下来就可以直接下载图片、或者把生成的代码放到 Mermaid 渲染工具中，就搞定了，非常方便。

![](https://pic.yupi.icu/1/1743563192886-178809e5-33de-4da0-b5da-f77961433a9c.png)

值得一提的是，现在有些 AI 大模型比如 [Gemini](https://gemini.google.com/) 已经原生支持多模态能力，可以直接生成图文混排的文章，再发展发展估计能直接根据代码生成有图有文的技术方案了吧。

------

OK，常用 AI 工具分享完了，看到这里，你应该就超过了 80% 的同学。

